
;
; This mimics the routine 'utplot' which is used for plotting light curves.
;

;
; This is a structure containing a light curve derived from an IRIS
; data-set. 
;
restore,'sji_light_curve_reg02.save'

;
; IDL needs to have the times converted to Julian Day format.
;
tt_jd=tim2jd(output.time)

time_string=anytim2utc(output.time[0],/vms,/date)+' '+ $
            anytim2utc(output.time[0],/ccsds,/time,/truncate)

p=plot(tt_jd,output.lc,xtickunits='time', $
       xtickformat='(C(CHI2.2,":",CMI2.2))', $
       ytitle='Intensity', $
       xtitle='Start Time ('+time_string+')', xsty=1)

END
