
;
; Simple plot example
;    - strings can accept latex math commands (e.g., $x$)
;    - for angstrom, $\AA$ is in italics so I have to use
;      old-fashioned way.
;

x=findgen(101)/100.*2.*!pi

p=plot( x, sin(x), color='red', xstyle=1, name='sin($x$)', $
        font_style='bold', $
        title='This is a title$^2$', $
        font_size=16, $
        xtitle='Wavelength, $\lambda$ / '+string(197b))

q=plot( x, cos(x), color='blue', /overplot, name='cos($x$)' )

leg=legend(target=[p,q], position=[0.2,-0.9], $
           horizontal_align='left', $
           vertical_align='bottom',/data)


END

        
