
;
; Multi-panel display for pros
;   - use position=[] keyword
;

!p.font=0
set_plot,'ps'
device,file='plot_direct_example4.ps',xsize=7,ysize=10,/inches,xoffset=0.5,yoffset=0.5

th=5

nx=2
ny=3
!p.multi=[0,nx,ny]

x0=0.02
x1=0.98
dx=(x1-x0)/float(nx)
ddx=0.05
;
y0=0.00
y1=0.96
dy=(y1-y0)/float(ny)
ddy=0.07

FOR i=0,1 DO BEGIN
  FOR j=0,2 DO BEGIN 
    plot,findgen(5), $
         position=[x0+ddx+i*dx,y0+ddy+j*dy,x0+(i+1)*dx,y0+(j+1)*dy], $
         title='Plot '+strtrim(i,2)+', '+strtrim(j,2), $
         charsize=2,thick=th,xthick=th,ythick=th
  ENDFOR
ENDFOR 

!p.multi=0

device,/close
set_plot,'x'
!p.font=-1

END

