
;
; ***FOR GSFC TUTORIAL PEOPLE***
; This routine was used to create the movie
; "movie_3panel_reg02.mp4". It won't work as it needs to read
; various data files, but by checking the IDL one can see how the
; 3-panel movie frames were created.  (Peter Young, 3-Mar-2016)
; 
;

PRO make_movie_hmi_sji_171, regnum

;+
; PURPOSE:
;     This is my "super-movie" routine that creates 3-panel movies for
;     the various spatial regions containing bursts.
;
; INPUTS:
;     Regnum:   An integer specifying the region for which the movie
;               is required. The regions are defined in the routine
;               DEFINE_MOVIE_REGNUM.
;
; OUTPUTS:
;     Writes image frames (png) into subdirectories of the form
;     frames_3panel_regN, where N is REGNUM.
;
; MODIFICATION HISTORY:
;     Ver.1, 18-Dec-2015, Peter Young
;-

regstr=define_movie_regions(regnum)

outdir=concat_dir('$PRY_DATA/iris/ar_22oct2013/movies',regstr.outdir)
chck=file_info(outdir)
IF chck.directory NE 1 THEN file_mkdir,outdir
chck=file_search(outdir,'*.png',count=n)
IF n NE 0 THEN file_delete,chck

;
; This contains the locations of the bursts. I do some filtering based
; on whether the bursts are inside the movie box.
;
restore,'si4_results.save'
n=n_elements(outstr)
newoutstr=0
FOR i=0,n-1 DO BEGIN
  xy=rot_xy(outstr[i].x,outstr[i].y,tstart=outstr[i].t,tend=regstr.tref)
  x=xy[0,0]
  y=xy[0,1]
  IF x GE regstr.xrange[0] AND x LE regstr.xrange[1] AND y GE regstr.yrange[0] AND y LE regstr.yrange[1] THEN BEGIN
    IF n_tags(newoutstr) EQ 0 THEN newoutstr=outstr[i] ELSE newoutstr=[newoutstr,outstr[i]]
  ENDIF 
ENDFOR
outstr=temporary(newoutstr)


;
; Read HMI data
;
list=file_search('$PRY_DATA/iris/ar_22oct2013/jsoc_hmi_45s','*.fits')
map=sdo2map(list,trange=[regstr.tstart,regstr.tend])
map=sdo_align_map(map,xrange=regstr.xrange,yrange=regstr.yrange,tref=regstr.tref)
print,'*** PROCESSED HMI IMAGES ***'


;
; Find SJI file
;
sjifile=iris_find_file('22-oct-2013 23:00',sji=1400)
imap=iris_sji2map(sjifile,tmatch=map.time)
imap=sdo_align_map(imap,xrange=regstr.xrange,yrange=regstr.yrange,tref=regstr.tref)
imap_tai=anytim2tai(imap.time)
print,'*** PROCESSED SJI IMAGES ***'



;
; Read AIA 171 data
;
list=file_search('$PRY_DATA/iris/ar_22oct2013/jsoc/respike','*_0171.fits')
amap=sdo2map(list,tmatch=map.time)
amap=sdo_align_map(amap,xrange=regstr.xrange,yrange=regstr.yrange,tref=regstr.tref)
amap_tai=anytim2tai(amap.time)
print,'*** PROCESSED AIA IMAGES ***'

junk=sigrange(amap.data,range=r)
junk=0
a_dmin=r[0]
a_dmax=r[1]


;
; Set intensity limits for SJI frames
; 
sji_dmin=70/8.0
sji_dmax=15000/8.0

n=n_elements(map)

hmi_dmax=regstr.hmi_max

x0=0.02
x1=0.98
dx=(x1-x0)/3.
ddx=0.05
y0=0.10
y1=0.94
th=2
fs=14
xtl=0.02
ytl=0.02

extra={xthick: th, ythick: th, xticklen: xtl, yticklen: ytl, font_size: fs}

FOR i=0,n-1 DO BEGIN
  print,'Processing image '+trim(i+1)+' of '+trim(n)+'...'
 ;
 ; Plot HMI image
 ; --------------
  title='HMI M_45s, '+anytim2utc(/ccsds,/time,/trunc,map[i].time)+' UT'
  p=plot_map_obj(/buffer,dim=[1100,400],map[i],dmin=-hmi_dmax,dmax=hmi_dmax, $
                 pos=[x0+ddx,y0,x0+dx,y1],rgb_table=0,title=title, $
                 _extra=extra)
  hmi_tai=anytim2tai(map[i].time)
 ;
  k=where(outstr.t_tai LE hmi_tai+300 AND outstr.t_tai GE hmi_tai-300,nk)
  IF nk NE 0 THEN BEGIN
    str={x: 0., y: 0.}
    pos_str=replicate(str,nk)
    FOR j=0,nk-1 DO BEGIN
      x=outstr[k[j]].x
      y=outstr[k[j]].y
      xy=rot_xy(x,y,tstart=outstr[k[j]].t,tend=map[i].time)
      pos_str[j].x=xy[0,0]
      pos_str[j].y=xy[0,1]
      px=plot(/overplot,pos_str[j].x*[1,1],pos_str[j].y*[1,1],sym_color='blue', $
              symbol='+',sym_size=1.5, $
              sym_thick=th)
    ENDFOR
  ENDIF 
 ;
 ; Plot SJI image
 ; --------------
  getmin=min(abs(hmi_tai-imap_tai),imin)
  title='SJI 1400, '+anytim2utc(/ccsds,/time,/trunc,imap[imin].time)+' UT'
  dmin=sji_dmin*imap[imin].dur
  dmax=sji_dmax*imap[imin].dur
  q=plot_map_obj(imap[imin],/log,pos=[x0+dx+ddx,y0,x0+2*dx,y1], $
                 rgb_table=aia_rgb_table(193),/current,dmin=dmin, $
                dmax=dmax,title=title,_extra=extra,ytitle='')
  IF nk NE 0 THEN BEGIN
    FOR j=0,nk-1 DO BEGIN
      qx=plot(/overplot,pos_str[j].x*[1,1],pos_str[j].y*[1,1],sym_color='black', $
              symbol='+',sym_size=1.5, $
              sym_thick=th)
    ENDFOR
  ENDIF 
 ;
 ; Plot AIA image
 ; --------------
  getmin=min(abs(hmi_tai-amap_tai),imin)
  title='AIA 171, '+anytim2utc(/ccsds,/time,/trunc,amap[imin].time)+' UT'
  r=plot_map_obj(amap[imin],/log,pos=[x0+2*dx+ddx,y0,x0+3*dx,y1], $
                 rgb_table=aia_rgb_table(171),/current,dmin=a_dmin, $
                 dmax=a_dmax,title=title,_extra=extra,ytitle='')
  IF nk NE 0 THEN BEGIN
    FOR j=0,nk-1 DO BEGIN
      rx=plot(/overplot,pos_str[j].x*[1,1],pos_str[j].y*[1,1],sym_color='blue', $
              symbol='+',sym_size=1.5, $
              sym_thick=th)
    ENDFOR
  ENDIF 
 ;
  outfile='image'+strpad(trim(i),4,fill='0')+'.png'
  outfile=concat_dir(outdir,outfile)
  p.save,outfile,resolution=96
  p.close
ENDFOR


END
