

;
; Multi-panel plot with better use of space
;    - using position=[]
;    - text object used for annotation (note use of target)  
;

x0=0.0
x1=0.97
dx=(x1-x0)/2.
ddx=0.06
;
y0=0.0
y1=0.95
dy=(y1-y0)/2.
ddy=0.10

p1=plot(findgen(5), position=[x0+ddx,y0+dy+ddy,x0+dx,y0+2*dy], $
        title='Plot 1', /current)

p2=plot(findgen(5), position=[x0+dx+ddx,y0+dy+ddy,x0+2*dx,y0+2*dy], $
        title='Plot 2', /current)

p3=plot(findgen(5), position=[x0+ddx,y0+ddy,x0+dx,y0+dy], $
        title='Plot 3', /current)

p4=plot(findgen(5), position=[x0+dx+ddx,y0+ddy,x0+2*dx,y0+dy], $
        title='Plot 4', /current)

t4=text(target=p4,/data,1,0.5,'This is my favorite!')

p1.save,'plot_obj_example4.eps',resolution=144

END
